//
//  hook.h
//  GProtocol
//
//  Created by Huang 黄嘉 on 11/25/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#ifndef HOOK_H
#define HOOK_H 1

#include <string>
#include <map>
using namespace std;

template<typename T, typename T_CALLBACK>
class HookData {
public:
	T_CALLBACK cb;
	void *pv;
};


template<typename T>
class Hook
{    
public:
	typedef void (*T_CALLBACK)(T*, const string &, void*, void *);
	typedef vector<HookData<T, T_CALLBACK>*> HOOKS;
	typedef map<string, HOOKS*> HOOK_MAP;

private:
	HOOK_MAP _map;

public:
	
	virtual ~Hook() {
		for (typename HOOK_MAP::iterator it=_map.begin(); it != _map.end(); it++) {
			HOOKS *hooks = it->second;
			for (typename HOOKS::iterator it2 = hooks->begin(); it2 != hooks->end(); it2++) {
				delete *it2;
			}
			delete hooks;
		}
		_map.clear();
	}
    
	void bind(const string &e, T_CALLBACK cb, void *pv=NULL) {
		// TRACE("Hook::bind(\"%s\")\n", e.c_str());
		HOOKS *hooks;
		typename HOOK_MAP::iterator it = _map.find(e);
		if (it == _map.end()) {
			hooks = new HOOKS;
			_map[e] = hooks;
		}
		else {
			hooks = it->second;
		}
		
		for (typename HOOKS::iterator it2 = hooks->begin(); it2 != hooks->end(); it2++) {
			HookData<T, T_CALLBACK> *p = *it2;
			if (p->cb == cb && p->pv == pv) {
				//don't bind the same cb&&pv  twice
				return;
			}
		}

		HookData<T, T_CALLBACK>* p = new HookData<T, T_CALLBACK>();
		p->cb = cb;
		p->pv = pv;
		hooks->push_back(p);
	}
	
	void trigger(const string &e, void *pv=NULL) {
		// TRACE("Hook::trigger(\"%s\")\n", e.c_str());
		typename HOOK_MAP::iterator it;
		it = _map.find(e);
		if (it != _map.end()) {
			HOOKS *hooks = it->second;
			for (typename HOOKS::iterator it2 = hooks->begin(); it2 != hooks->end(); it2++) {
				HookData<T, T_CALLBACK> *p = *it2;
				if (p->cb) {
					p->cb(static_cast<T*>(this), e, p->pv, pv);
				}
			}
		}
	}
    
	bool has_trigger(const string &e) {
		typename HOOK_MAP::iterator it;
		it = _map.find(e);
		return it != _map.end();
	}

	void unbind(const string &e, T_CALLBACK cb=NULL, void *pv=NULL) {
		typename HOOK_MAP::iterator it;
		it = _map.find(e);
		if (it != _map.end()) {
			HOOKS *hooks = it->second;
			typename HOOKS::iterator it2;
			if (cb == NULL) {
				for (it2 = hooks->begin(); it2 != hooks->end(); it2++) {
					delete *it2;
				}
				delete hooks;
				_map.erase(it);
			}
			else {
				for (it2 = hooks->begin(); it2 != hooks->end();) {
					HookData<T, T_CALLBACK> *p = *it2;
					if (p->cb == cb && p->pv == pv) {
						delete p;
						it2 = hooks->erase(it2);
					}
					else {
						++ it2;
					}
				}
				if (hooks->size() == 0) {
					delete hooks;
					_map.erase(it);
				}
			}
		}
	}
    
	void unbind(void *pv) {
		typename HOOK_MAP::iterator it;
		for (it = _map.begin(); it != _map.end();) {
			HOOKS *hooks = it->second;
			typename HOOKS::iterator it2;
			for (it2 = hooks->begin(); it2 != hooks->end();) {
				HookData<T, T_CALLBACK> *p = *it2;
				if (p->pv == pv) {
					delete p;
					it2 = hooks->erase(it2);
				}
				else {
					++ it2;
				}
			}

			if (hooks->size() == 0) {
				delete hooks;
				typename HOOK_MAP::iterator it_next = it;
				it_next ++;
				_map.erase(it);
				it = it_next;
			}
			else {
				++ it;
			}
		}
	}
};

#endif // HOOK_H