//
//  grsa.cpp
//  GLogon
//
//  Created by Huang 黄嘉 on 11/26/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#include "common.h"
#include <openssl/pem.h>
#include <openssl/rsa.h>
#include "grsa.h"

bool GRSA::verify(const string & signature, const string& message, const string &publicKey) {
	RSA *publicRSA = NULL;
	BIO *bin = BIO_new_mem_buf((void *)publicKey.c_str(), (int) publicKey.length());
	if (bin) {
		publicRSA = PEM_read_bio_RSA_PUBKEY(bin, NULL, NULL, NULL);
		BIO_free_all(bin);
	}
    
	bool verified = false;
	if (publicRSA) {
		unsigned char md[SHA_DIGEST_LENGTH];
		SHA1((const unsigned char *)message.c_str(), message.length(), md);
		if (RSA_verify(NID_sha1, md, SHA_DIGEST_LENGTH, (unsigned char *)signature.c_str(), (unsigned int) signature.length(), publicRSA)) {
			verified = true;
		}
		RSA_free(publicRSA);
	}
    
	return verified;
}

string GRSA::sign(const string &message, const string &privateKey) {
	RSA *privateRSA = NULL;
	BIO *bin = BIO_new_mem_buf((void *)privateKey.c_str(), (int) privateKey.length());
	if (bin) {
		privateRSA = PEM_read_bio_RSAPrivateKey(bin, NULL, NULL, NULL);
		BIO_free_all(bin);
	}
    
	string signature;
    
	if (privateRSA) {
		unsigned char md[SHA_DIGEST_LENGTH];
		unsigned char *sigbuf = new unsigned char[RSA_size(privateRSA)];
		unsigned int sigbuf_len = 0;
		SHA1((const unsigned char *)message.c_str(), message.length(), md);
		if (RSA_sign(NID_sha1, md, SHA_DIGEST_LENGTH, sigbuf, &sigbuf_len, privateRSA)) {
			signature.append((const char*)sigbuf, sigbuf_len);
		}
		delete []sigbuf;
		RSA_free(privateRSA);
	}
    
	return signature;
}

string GRSA::encrypt(const string &message, const string &publicKey) {
	RSA *publicRSA = NULL;
	BIO *bin = BIO_new_mem_buf((void *)publicKey.c_str(), (int) publicKey.length());
	if (bin) {
		publicRSA = PEM_read_bio_RSA_PUBKEY(bin, NULL, NULL, NULL);
		BIO_free_all(bin);
	}
    
	string code;
	if (publicRSA) {
		unsigned char *code_buf = new unsigned char[RSA_size(publicRSA)];
		int code_len = RSA_public_encrypt((int) message.length(), (const unsigned char *)message.c_str(), code_buf, publicRSA, RSA_PKCS1_PADDING);
		if (code_len > 0) {
			code.append((char *)code_buf, code_len);
		}
		delete []code_buf;
		RSA_free(publicRSA);
	}
    
	return code;
}

string GRSA::decrypt(const string &digest, const string &privateKey) {
	RSA *privateRSA = NULL;
	BIO *bin = BIO_new_mem_buf((void *)privateKey.c_str(), (int) privateKey.length());
	if (bin) {
		privateRSA = PEM_read_bio_RSAPrivateKey(bin, NULL, NULL, NULL);
		BIO_free_all(bin);
	}
    
	string source;
	if (privateRSA) {
		unsigned char *source_buf = new unsigned char[RSA_size(privateRSA)];
		int source_len = RSA_private_decrypt((int) digest.length(), (const unsigned char *)digest.c_str(), source_buf, privateRSA, RSA_PKCS1_PADDING);
		if (source_len > 0) {
			source.append((char *)source_buf, source_len);
		}
		delete []source_buf;
		RSA_free(privateRSA);
	}
    
	return source;
}