//
//  network.h
//  GProtocol
//
//  Created by Huang 黄嘉 on 11/25/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#ifndef GNETWORK_H
#define GNETWORK_H 1

class GNetwork:public Hook<GNetwork>
{
    struct bufferevent *_sock_event;
	struct event *_reconnect_event;
    
    bool _is_connected;
	bool _is_alive;
    
    string _host;
    int _port;
    
	struct event_base *_event_base;
    
	bool _check_alive;
	bool _is_session_disconnect;

public:
	inline void session_disconnect(bool is_disconnect){_is_session_disconnect = is_disconnect;} 

    string client_code;
    string server_code;
    
    GNetwork(struct event_base *, bool check_alive=true);
    virtual ~GNetwork();
    
    bool connect();
    bool connect(const string& host, int port);
    void disconnect();
    void reconnect();
	void idle();
    void post_command(const Json::Value &);
        
    void on_read();
    
    void dispatch_command(const Json::Value&);
    
    bool is_connected();

};

#endif // GNETWORK_H