//
//  gcipher.cpp
//  GLogon
//
//  Created by Huang 黄嘉 on 11/26/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#include "common.h"

#include <openssl/ssl.h>
#include <openssl/evp.h>
#include "gbase64.h"
#include "gcipher.h"

#define CIPHER_METHOD "des"

void GCipher::init() {
	static bool _inited = false;
	if (!_inited) {
		OpenSSL_add_all_ciphers();
		_inited = true;
	}
}

string GCipher::encrypt(const string &source, const string &password, bool b64) {
    char *iv;
    int iv_len;
    const EVP_CIPHER *cipher_type;
    EVP_CIPHER_CTX cipher_ctx;
    int i, outlen, keylen;
    unsigned char *outbuf, *key;
    
	GCipher::init();
    
	cipher_type = EVP_get_cipherbyname(CIPHER_METHOD);
    
    keylen = EVP_CIPHER_key_length(cipher_type);
    if (keylen > (int) password.length()) {
        key = new unsigned char[keylen];
        memset(key, 0, keylen);
        memcpy(key, password.c_str(), password.length());
    } else {
        key = (unsigned char*)password.c_str();
    }    
    
    iv_len = EVP_CIPHER_iv_length(cipher_type);
	iv = new char[iv_len];
	memset(iv, 0, iv_len);
    
	outlen = (int) source.length() + EVP_CIPHER_block_size(cipher_type);
    outbuf = new unsigned char[outlen];
    
	string code;
    
	EVP_EncryptInit(&cipher_ctx, cipher_type, key, (unsigned char *)iv);
    EVP_EncryptUpdate(&cipher_ctx, outbuf, &i, (unsigned char *)source.c_str(), (int) source.length());
    outlen = i; 
    if (EVP_EncryptFinal(&cipher_ctx, (unsigned char *)outbuf + i, &i)) {
        outlen += i;
		code.append((char *)outbuf, outlen); 
	} 
	
	delete[] outbuf;
    
	if (key != (unsigned char*)password.c_str()) {
        delete[] key;
    }
    
	delete[] iv;
    
	return b64 ? GBase64::encode(code) : code;
}

string GCipher::decrypt(const string &code, const string &password, bool b64) {
    char *iv;
    int iv_len;
    const EVP_CIPHER *cipher_type;
    EVP_CIPHER_CTX cipher_ctx;
    int i, outlen, keylen;
    unsigned char *outbuf, *key;
    
	string raw_code = b64 ? GBase64::decode(code) : code;
    
	GCipher::init();
    
	cipher_type = EVP_get_cipherbyname(CIPHER_METHOD);
    
    keylen = EVP_CIPHER_key_length(cipher_type);
    if (keylen > (int) password.length()) {
        key = new unsigned char[keylen];
        memset(key, 0, keylen);
        memcpy(key, password.c_str(), password.length());
    } else {
        key = (unsigned char*)password.c_str();
    }    
    
    iv_len = EVP_CIPHER_iv_length(cipher_type);
	iv = new char[iv_len];
	memset(iv, 0, iv_len);
    
	outlen = (int) raw_code.length() + EVP_CIPHER_block_size(cipher_type);
    outbuf = new unsigned char[outlen];
    
	string source;
    
	EVP_DecryptInit(&cipher_ctx, cipher_type, key, (unsigned char *)iv);
    EVP_DecryptUpdate(&cipher_ctx, outbuf, &i, (unsigned char *)raw_code.c_str(), (int) raw_code.length());
    outlen = i; 
    if (EVP_DecryptFinal(&cipher_ctx, (unsigned char *)outbuf + i, &i)) {
        outlen += i;
		source.append((char *)outbuf, outlen); 
	} 
	
	delete[] outbuf;
    
	if (key != (unsigned char*)password.c_str()) {
        delete[] key;
    }
    
	delete[] iv;
    
	return source;
}