//
//  gGBase64.cpp
//  GLogon
//
//  Created by Huang 黄嘉 on 11/26/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#include "common.h"
#include <openssl/evp.h>
#include <openssl/bio.h>
#include <openssl/buffer.h>
#include "gbase64.h"

string GBase64::encode(const string &s) {
	return GBase64::encode((const unsigned char *)s.c_str(), (int) s.length());
}

string GBase64::encode(const unsigned char *b, int blen) {
	BIO *bmem, *b64;
	BUF_MEM *bptr;
    
	b64 = BIO_new(BIO_f_base64());
	BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    
	bmem = BIO_new(BIO_s_mem());
    
	b64 = BIO_push(b64, bmem);
	BIO_write(b64, b, blen);
	// BIO_flush(b64);
    BIO_ctrl(b64, BIO_CTRL_FLUSH, 0, NULL);
	BIO_get_mem_ptr(b64, &bptr);
    
	string ns(bptr->data, bptr->length);
    
	BIO_free_all(b64);
    
	return ns;
}

string GBase64::decode(const string &s) {
	BIO *bmem, *b64;
    
	int slen = (int) s.length();
	char *buf = (char*) malloc(slen);
    
	b64 = BIO_new(BIO_f_base64());
	BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    
	bmem = BIO_new_mem_buf((void *)s.c_str(), slen);
	bmem = BIO_push(b64, bmem);
	slen = BIO_read(bmem, buf, slen);
    
	BIO_free_all(bmem);
    
	string ns(buf, slen);
	free(buf);
    
	return ns;
}