//
//  equipment.h
//  GLogon
//
//  Created by Huang 黄嘉 on 11/27/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#ifndef EQUIPMENT_H
#define EQUIPMENT_H 1

#include "hook.h"
#include "gnetwork.h"
#include "database.h"

#ifdef WIN32 
#ifndef THREAD_PROC	
#define THREAD_PROC DWORD WINAPI
#endif
#else
#ifndef THREAD_PROC
#define THREAD_PROC void *
#endif
#endif

typedef void (*EQUIPMENT_CALLBACK)(void *);

class EQ_Plugin;

class EQ_User {
public:
    string token;
    string name;
	string card;
};

class Equipment:public Hook<Equipment>
{
    struct event_base *_event_base;

	struct evconnlistener *_listener;

	bool _is_ready;
    
	GNetwork *_network;

	friend class EQ_Plugin;

	vector<EQ_Plugin*> _plugins;

	Database _db;
	
public:

	static void init();
	static void uninit();
	
	Equipment(struct event_base *eb);
	~Equipment();

	GNetwork *network() { return _network; }

    void start();
	void stop();
	void accept(evutil_socket_t sock);

	void register_plugin(EQ_Plugin *p);
	void unregister_plugin(EQ_Plugin *p);
	void update_plugins();
    
	//Server Parameters
	EQ_User current_user;
	EQ_User last_user;
   
	int dtstart;
    int server_dtoffset;

	int reserv_dtstart;
    int reserv_dtend;
       
	bool is_reserv;

	string super_code;
    
    string language;
	string version;
	string platform;
	int pid;
    
	map<string, string> projects;
	map<string, string> backends;    
	string default_backend;

    string machine_id();
    void update_super_code();
    
    bool is_logged_in();    
	bool is_ready();
	    
	//命令
	static void on_connect(GNetwork *network, const string &, void *pv1, void *pv2);
	static void on_disconnect(GNetwork *network, const string &, void *pv1, void *pv2);
	static void on_idle(GNetwork *network, const string &, void *pv1, void *pv2);
    
    static void on_command_connect(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_install(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_message(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_login(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_logout(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_password(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_backends(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_projects(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_status(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_update_reserv(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_server_time(GNetwork *network, const string &, void *pv1, void *pv2);
    static void on_command_update(GNetwork *network, const string &, void *pv1, void *pv2); 
    static void on_command_plugins(GNetwork *network, const string &, void *pv1, void *pv2); 
    static void on_command_cards(GNetwork *network, const string &, void *pv1, void *pv2); 
    static void on_command_confirm_record(GNetwork *network, const string &, void *pv1, void *pv2); 
	static void on_command_cam_channels(GNetwork *network, const string &, void *pv1, void *pv2);
	static void on_command_cam_capture(GNetwork *network, const string &, void *pv1, void *pv2);

    // actions
    void update_offline_password();
	void login_with_token(const string &token, const string &backend, const string &password);
	void login_with_card(const string &card);
    void logout(int status, const string &project, const string &feedback, int samples);
	void logout();
	void update_projects();

	void update_offline_record(const Json::Value &o);
	void upload_offline_record();
};

#endif
