#ifndef EQ_PLUGIN_H
#define EQ_PLUGIN_H

class Equipment;

class EQ_Plugin {
	Equipment *_equipment;
    struct bufferevent *_sock_event;

	string name;
	string version;

	friend class Equipment;

public:
	EQ_Plugin(Equipment *equipment, evutil_socket_t);
	~EQ_Plugin();

	void on_read();
	void release();

	static void on_ready(Equipment *equipment, const string &, void *pv1, void *pv2);
	static void on_not_ready(Equipment *equipment, const string &, void *pv1, void *pv2);
	static void on_login(Equipment *equipment, const string &, void *pv1, void *pv2);
	static void on_logout(Equipment *equipment, const string &, void *pv1, void *pv2);

	static void on_command(GNetwork *network, const string &, void *pv1, void *pv2);

	void post_command(const Json::Value &o);

};


#endif //EQ_PLUGIN_H