#ifndef DATABASE_H
#define DATABASE_H

#include <sqlite3.h>

class Database
{
public:
    Database();
    virtual ~Database();

    bool open(const string&);
    void close(void);

    Json::Value query(const string&);
    Json::Value value(const string&);

    static string rewrite(const char *fmt, ...);

protected:
private:
    sqlite3 *_h;
    Json::Value _result;

    static int _query_cb(void *pv, int n_cols, char** col_vals, char** col_names);
};

#endif // DATABASE_H
