#include "common.h"
#include "database.h"

Database::Database()
{
    //ctor
    _h = NULL;
}

Database::~Database()
{
    //dtor
    close();
}

bool Database::open(const string& path) {
    close();

    TRACE("Database::open(%s)\n", path.c_str());
    return SQLITE_OK == sqlite3_open(path.c_str(), &_h);
}

void Database::close(void) {
    if (_h) {
        sqlite3_close(_h);
        _h = NULL;
    }
}

int Database::_query_cb(void *pv, int n_cols, char** col_vals, char** col_names) {
    Database *db = static_cast<Database *>(pv);
    Json::Value o;
    for (int i=0; i< n_cols; i++) {
        o[col_names[i]] = col_vals[i];
    }
    db->_result.append(o);
    TRACE("Database::_query_cb\n");
    return 0;
}

Json::Value Database::query(const string& sql) {
    char *errmsg = NULL;
    _result.clear();

    const char *s = sql.c_str();

    TRACE("Database::query(%s)\n", s);

    int err = sqlite3_exec(_h, s, _query_cb, this, &errmsg);
    if (err != SQLITE_OK) {
        TRACE("Database::query error %d\n", err);
    }

#ifdef _DEBUG
    Json::FastWriter writer;
    TRACE("Database::query return %s", writer.write(_result).c_str());
#endif

    return _result;
}

Json::Value Database::value(const string& sql) {
    const Json::Value r = query(sql);
    if (r[0u].isObject()) {
        Json::ValueConstIterator i = r[0u].begin();
        if (i != r[0u].end()) return *i;
    }
    return Json::nullValue;
}

string Database::rewrite(const char* fmt, ...) {
    /* Guess we need no more than 100 bytes. */
    char *p;
    va_list ap;

    va_start(ap, fmt);
    p = sqlite3_vmprintf(fmt, ap);
    va_end(ap);

    if (!p) return "";

    string s(p);
    sqlite3_free(p);

    return s;
}
