//
//  common.h
//  GProtocol
//
//  Created by Huang 黄嘉 on 11/25/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#ifndef COMMON_H_INCLUDED
#define COMMON_H_INCLUDED 1

#define GLOGON_ADMIN "administrator"
#define GLOGON_ADMIN_NAME "Administrator"

#define GLOGON_DB ".glogon.db"

#define CAPTURE_WIDTH 800
#define CAPTURE_HEIGHT 600

#define CAM_WIDTH 640
#define CAM_HEIGHT 480

#define EQUIPMENT_PORT	9730

#ifdef WIN32 
#ifndef THREAD_PROC	
#define THREAD_PROC DWORD WINAPI
#endif
#else
#ifndef THREAD_PROC
#define THREAD_PROC void *
#endif
#endif

#ifndef __STDC_CONSTANT_MACROS
#define __STDC_CONSTANT_MACROS	1
#endif

#ifdef WIN32
#	if defined(_DEBUG) && !defined(DEBUG)
#		define DEBUG
#	endif
#endif

extern "C" {
#include <errno.h>

#include <event2/event.h>
#include <event2/util.h>
#include <event2/bufferevent.h>
#include <event2/buffer.h>
#include <event2/thread.h>
#include <event2/listener.h>

}

#include <curl/curl.h>
#include <sqlite3.h>

#include <string>
#include <sstream>
#include <queue>
#include <map>
#include <vector>

using namespace std;
string string_format(const char *fmt, ...);
string temp_filename();

#include <json/json.h>
#define J(x) Json::Value(x)

const string J_STR(const Json::Value &o);
const char *J_CSTR(const Json::Value &o);
int J_INT(const Json::Value &o);
long UTICK();
long MULDIV(long a, int b, int c);
const string get_home();

#ifdef WIN32
	bool THREAD_IS_RUNNING(HANDLE x);
#	ifdef DEBUG
#		define STOP_THREAD(x) 	do { if (WAIT_TIMEOUT == ::WaitForSingleObject(x, 5000)) { TRACE("stop_thread timeout " #x "\n"); } ::CloseHandle(x); x = NULL; } while(0)
#	else
#		define STOP_THREAD(x) 	do { ::WaitForSingleObject(x, INFINITE); ::CloseHandle(x); x = NULL; } while(0)
#	endif
#else
	#define THREAD_IS_RUNNING(x) (x)
	#define STOP_THREAD(x) 	do {void *_ptr_; pthread_join(x, &_ptr_); x = NULL; } while(0)
#endif

#ifdef WIN32 
#	define unlink	_unlink
#	define usleep	Sleep
#	define snprintf _snprintf
#endif

#if (defined(DEBUG) || defined(DTRACE))

#	ifdef WIN32
#		include <atltrace.h>
#		include <atltime.h>
#		define TRACE(...) do{TCHAR _name[MAX_PATH]; ::GetModuleFileName(NULL, _name, MAX_PATH); ATLTRACE(_T("%s %s[0x%04lx] "), CTime::GetCurrentTime().Format(_T("%H:%M:%S")), _tcsrchr(_name, _T('\\')), ::GetCurrentThreadId()); ATLTRACE(__VA_ARGS__); } while(0)
#	else
#		define TRACE(args...) fprintf(stderr, ##args)
#	endif //WIN32

#	define HEXTRACE(s,l) do{int i; for(i=0;i<l;i++){fprintf(stderr, "%02X ", (uchar_t)s[i]);} } while(0)

#else

#	ifdef WIN32
#		define TRACE(...) do {} while(0)
#		define HEXTRACE(s,l) do {} while(0)
#	else
#		define TRACE(args...) do {} while(0)	
#		define HEXTRACE(s,l) do {} while(0)
#	endif

#endif //DEBUG

#define NOW() ((int)::time(0))

#include "hook.h"

#endif // COMMON_H_INCLUDED