//
//  common.cpp
//  GLogon
//
//  Created by Huang 黄嘉 on 11/27/11.
//  Copyright (c) 2011 基理科技. All rights reserved.
//

#include "common.h"
#ifdef WIN32
#include <tchar.h>
#include <atlstr.h>
#include <shlobj.h>
#else
#include <pwd.h>
#endif

const string J_STR(const Json::Value &o) {
	return o.isString() ? o.asString() : "";
}

const char *J_CSTR(const Json::Value &o) {
	return o.isString() ? o.asCString() : "";
}

int J_INT(const Json::Value &o) {
	return o.isString() ? atoi(o.asCString()) : (o.isInt() ? o.asInt() : 0);
}

string string_format(const char *fmt, ...) {
	int n, size=100;
	string str;
	va_list ap;
	while (1) {
		str.resize(size);
		va_start(ap, fmt);
		n = vsnprintf((char *)str.c_str(), size, fmt, ap);
		va_end(ap);
		if (n > -1 && n < size)
			return str;
		if (n > -1)
			size=n+1;
		else
			size*=2;
	}
}

#ifdef WIN32
#define T2UA(x) ((const char *)CT2A(x, CP_UTF8))
#define UA2T(x) CA2T(x, CP_UTF8)

#define S2T(x) UA2T(x##.c_str())
#define T2S(x) string(T2UA(x))
#endif

string temp_filename() {
#ifdef WIN32
	USES_CONVERSION;
	TCHAR szTempPath[MAX_PATH - 14];
	TCHAR szTempImage[MAX_PATH];
	::GetTempPath(MAX_PATH - 14, szTempPath);
	::GetTempFileName(szTempPath, _T("GLogon"), 0, szTempImage);
	string s = CT2A(szTempImage, CP_UTF8);
	return s;
#else
	char *fn = tempnam(NULL, "glogon");
	string s = fn;
	free(fn);
	return s;
#endif
}

long UTICK() {
#ifdef WIN32
	return ::timeGetTime();
#else
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return (tv.tv_sec & 0xffff) * 1000 + tv.tv_usec;
#endif
}

long MULDIV(long a, int b, int c){
#ifdef WIN32
	return ::MulDiv(a, b, c);
#else
	long whole = a/c*b;
	long fraction1 = (a%c)*(b/c);
	long fraction2 = (a%c)*(b%c)/c;
	
	return whole + fraction1 + fraction2;
#endif
}

#ifdef WIN32
bool THREAD_IS_RUNNING(HANDLE x) { 
	DWORD code=0; 
	return x && ::GetExitCodeThread(x, &code) && code == STILL_ACTIVE; 
}
#endif

#ifdef WIN32
const string get_home() {
	USES_CONVERSION;
	TCHAR path[MAX_PATH];
	if (SUCCEEDED(SHGetFolderPath(NULL, CSIDL_PROFILE, NULL, 0, path))) {
		return T2UA(path);
	}

	return "";
}
#else
const string get_home() {
    struct passwd *pw = getpwuid(getuid());
    return pw->pw_dir ?: "";
}
#endif