/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.face.util;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ImageUtils {
    private static final int FACE_DETECT_IMAGE_WIDTH_LIMIT = 4;
    private static final int FACE_DETECT_IMAGE_HEIGHT_LIMIT = 2;
    private static final int VALUE_FOR_4_ALIGN = 3;
    private static final int VALUE_FOR_2_ALIGN = 1;

    public static byte[] bitmapToBgr24(Bitmap image) {
        if (image == null) {
            return null;
        }
        if (image.getConfig() != Bitmap.Config.ARGB_8888) {
            image = image.copy(Bitmap.Config.ARGB_8888, true);
        }
        int bytes = image.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        image.copyPixelsToBuffer((Buffer)buffer);
        byte[] rgbaData = buffer.array();
        int pixelCount = rgbaData.length / 4;
        byte[] bgrData = new byte[pixelCount * 3];
        int rgbaIndex = 0;
        int bgrIndex = 0;
        for (int i = 0; i < pixelCount; ++i) {
            bgrData[bgrIndex] = rgbaData[rgbaIndex + 2];
            bgrData[bgrIndex + 1] = rgbaData[rgbaIndex + 1];
            bgrData[bgrIndex + 2] = rgbaData[rgbaIndex];
            bgrIndex += 3;
            rgbaIndex += 4;
        }
        return bgrData;
    }

    public static Bitmap bgrToBitmap(byte[] bgr, int width, int height) {
        int[] colors = ImageUtils.convertBgrToColor(bgr);
        if (colors == null) {
            return null;
        }
        return Bitmap.createBitmap((int[])colors, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private static int[] convertBgrToColor(byte[] bgr) {
        int size = bgr.length;
        if (size == 0) {
            return null;
        }
        if (size % 3 != 0) {
            return null;
        }
        int[] color = new int[size / 3];
        int index = 0;
        for (int i = 0; i < color.length; ++i) {
            color[i] = (bgr[index + 2] & 0xFF) << 16 | (bgr[index + 1] & 0xFF) << 8 | bgr[index] & 0xFF | 0xFF000000;
            index += 3;
        }
        return color;
    }

    public static Bitmap alignBitmapForBgr24(Bitmap bitmap) {
        if (bitmap == null || bitmap.getWidth() < 4) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if ((width & 3) != 0) {
            bitmap = ImageUtils.cropImage(bitmap, new Rect(0, 0, width &= 0xFFFFFFFC, height));
        }
        return bitmap;
    }

    public static Bitmap cropImage(Bitmap bitmap, Rect rect) {
        if (bitmap == null || rect == null || rect.isEmpty() || bitmap.getWidth() < rect.right || bitmap.getHeight() < rect.bottom) {
            return null;
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), null, (boolean)false);
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, float rotateDegree) {
        if (bitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate(rotateDegree);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
    }

    public static byte[] cropNv21(byte[] nv21, int width, int height, Rect rect) {
        if (nv21 == null || nv21.length == 0 || width * height * 3 / 2 != nv21.length || rect == null) {
            throw new IllegalArgumentException("invalid image params!");
        }
        if (rect.left < 0 || rect.top < 0 || rect.right > width || rect.bottom > height) {
            throw new IllegalArgumentException("rect out of bounds!");
        }
        if (rect.right <= rect.left || rect.bottom <= rect.top) {
            throw new IllegalArgumentException("invalid rect!");
        }
        if ((rect.right - rect.left & 1) == 1 || (rect.bottom - rect.top & 1) == 1) {
            throw new IllegalArgumentException("nv21 width and height must be even!");
        }
        int cropImageWidth = rect.right - rect.left;
        int cropImageHeight = rect.bottom - rect.top;
        byte[] cropNv21 = new byte[cropImageWidth * cropImageHeight * 3 / 2];
        int originalYLineStart = rect.top * width;
        int targetYIndex = 0;
        int originalUVLineStart = width * height + rect.top * width / 2;
        int targetUVIndex = cropImageWidth * cropImageHeight;
        for (int i = rect.top; i < rect.bottom; ++i) {
            System.arraycopy(nv21, originalYLineStart + rect.left, cropNv21, targetYIndex, cropImageWidth);
            originalYLineStart += width;
            targetYIndex += cropImageWidth;
            if ((i & 1) != 0) continue;
            System.arraycopy(nv21, originalUVLineStart + rect.left, cropNv21, targetUVIndex, cropImageWidth);
            originalUVLineStart += width;
            targetUVIndex += cropImageWidth;
        }
        return cropNv21;
    }

    public static byte[] cropBgr24(byte[] bgr24, int width, int height, Rect rect) {
        if (bgr24 == null || bgr24.length == 0 || width * height * 3 != bgr24.length || rect == null) {
            throw new IllegalArgumentException("invalid image params!");
        }
        if (rect.left < 0 || rect.top < 0 || rect.right > width || rect.bottom > height) {
            throw new IllegalArgumentException("rect out of bounds!");
        }
        if (rect.right <= rect.left || rect.bottom <= rect.top) {
            throw new IllegalArgumentException("invalid rect!");
        }
        int cropImageWidth = rect.right - rect.left;
        int cropImageHeight = rect.bottom - rect.top;
        byte[] cropBgr24 = new byte[cropImageWidth * cropImageHeight * 3];
        int originalLineStart = rect.top * width * 3;
        int targetIndex = 0;
        for (int i = rect.top; i < rect.bottom; ++i) {
            System.arraycopy(bgr24, originalLineStart + rect.left * 3, cropBgr24, targetIndex, cropImageWidth * 3);
            originalLineStart += width * 3;
            targetIndex += cropImageWidth * 3;
        }
        return cropBgr24;
    }
}

