/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.face;

import android.content.Context;
import android.graphics.Rect;
import com.arcsoft.face.ActiveFileInfo;
import com.arcsoft.face.AgeInfo;
import com.arcsoft.face.ErrorInfo;
import com.arcsoft.face.FaceFeature;
import com.arcsoft.face.FaceFeatureInfo;
import com.arcsoft.face.FaceInfo;
import com.arcsoft.face.FaceSimilar;
import com.arcsoft.face.GenderInfo;
import com.arcsoft.face.ImageQualitySimilar;
import com.arcsoft.face.LivenessInfo;
import com.arcsoft.face.LivenessParam;
import com.arcsoft.face.MaskInfo;
import com.arcsoft.face.SearchResult;
import com.arcsoft.face.VersionInfo;
import com.arcsoft.face.enums.CompareModel;
import com.arcsoft.face.enums.DetectFaceOrientPriority;
import com.arcsoft.face.enums.DetectMode;
import com.arcsoft.face.enums.DetectModel;
import com.arcsoft.face.enums.DeviceIdPriority;
import com.arcsoft.face.enums.ExtractType;
import com.arcsoft.face.enums.MACPriority;
import com.arcsoft.face.enums.RuntimeABI;
import com.arcsoft.face.model.ActiveDeviceInfo;
import com.arcsoft.face.model.ArcSoftImageInfo;
import com.arcsoft.face.model.CustomDeviceInfo;
import java.util.List;

public class FaceEngine {
    public static final int ASF_NONE = 0;
    public static final int ASF_FACE_DETECT = 1;
    public static final int ASF_FACE_RECOGNITION = 4;
    public static final int ASF_AGE = 8;
    public static final int ASF_GENDER = 16;
    public static final int ASF_LIVENESS = 128;
    public static final int ASF_IMAGEQUALITY = 512;
    public static final int ASF_IR_LIVENESS = 1024;
    public static final int ASF_MASK_DETECT = 4096;
    public static final int ASF_UPDATE_FACEDATA = 8192;
    public static final int CP_PAF_NV21 = 2050;
    public static final int CP_PAF_BGR24 = 513;
    public static final int CP_PAF_GRAY = 1793;
    public static final int CP_PAF_DEPTH_U16 = 3074;
    public static final int ASF_OC_0 = 1;
    public static final int ASF_OC_90 = 2;
    public static final int ASF_OC_270 = 3;
    public static final int ASF_OC_180 = 4;
    public static final int ASF_OC_30 = 5;
    public static final int ASF_OC_60 = 6;
    public static final int ASF_OC_120 = 7;
    public static final int ASF_OC_150 = 8;
    public static final int ASF_OC_210 = 9;
    public static final int ASF_OC_240 = 10;
    public static final int ASF_OC_300 = 11;
    public static final int ASF_OC_330 = 12;
    private long handle = 0L;
    private ErrorInfo initError = new ErrorInfo();
    private ErrorInfo detectError = new ErrorInfo();
    private ErrorInfo processError = new ErrorInfo();
    private ErrorInfo processIrError = new ErrorInfo();
    private ErrorInfo detectQualityError = new ErrorInfo();
    private ErrorInfo frError = new ErrorInfo();
    private FaceInfo[] mFaceInfoArray;
    private AgeInfo[] mAgeInfoArray;
    private GenderInfo[] mGenderInfoArray;
    private LivenessInfo[] mLivenessInfoArray;
    private LivenessInfo[] mIrLivenessInfoArray;
    private MaskInfo[] mMaskInfoArray;

    private static native int nativeGetActiveDeviceInfo(Context var0, ActiveDeviceInfo var1);

    private native long nativeInitFaceEngine(Context var1, long var2, int var4, int var5, int var6, ErrorInfo var7);

    private static native void nativeSetMACPriority(int var0);

    private static native void nativeSetDeviceIdPriority(int var0);

    private static native int nativeActiveFaceEngineOnline(Context var0, String var1, String var2, String var3);

    private static native int nativeActiveFaceEngineOffline(Context var0, String var1);

    private static native int nativeGetActiveFile(Context var0, ActiveFileInfo var1);

    private native int nativeUnInitFaceEngine(long var1);

    private native int nativeDetectFaces(long var1, byte[] var3, int var4, int var5, int var6, int var7, FaceInfo[] var8, ErrorInfo var9);

    private native int nativeDetectFaces(long var1, ArcSoftImageInfo var3, int var4, FaceInfo[] var5, ErrorInfo var6);

    private native int nativeUpdateFaceData(long var1, byte[] var3, int var4, int var5, int var6, FaceInfo[] var7);

    private native int nativeUpdateFaceData(long var1, ArcSoftImageInfo var3, FaceInfo[] var4);

    private native void nativeProcess(long var1, byte[] var3, int var4, int var5, int var6, FaceInfo[] var7, int var8, ErrorInfo var9);

    private native void nativeProcess(long var1, ArcSoftImageInfo var3, FaceInfo[] var4, int var5, ErrorInfo var6);

    private native void nativeProcessIr(long var1, byte[] var3, int var4, int var5, int var6, FaceInfo[] var7, int var8, ErrorInfo var9);

    private native void nativeProcessIr(long var1, ArcSoftImageInfo var3, FaceInfo[] var4, int var5, ErrorInfo var6);

    private native void nativeExtractFaceFeature(long var1, byte[] var3, int var4, int var5, int var6, Rect var7, int var8, byte[] var9, int var10, int var11, int var12, byte[] var13, ErrorInfo var14);

    private native void nativeExtractFaceFeature(long var1, ArcSoftImageInfo var3, Rect var4, int var5, byte[] var6, int var7, int var8, int var9, byte[] var10, ErrorInfo var11);

    private native float nativeImageQualityDetect(long var1, byte[] var3, int var4, int var5, int var6, Rect var7, int var8, byte[] var9, int var10, int var11, ErrorInfo var12);

    private native float nativeImageQualityDetect(long var1, ArcSoftImageInfo var3, Rect var4, int var5, byte[] var6, int var7, int var8, ErrorInfo var9);

    private native float nativePairMatching(long var1, byte[] var3, byte[] var4, int var5, ErrorInfo var6);

    private native SearchResult nativeSearchFaceFeature(long var1, byte[] var3, int var4);

    private native int nativeRegisterFaceFeature(long var1, FaceFeatureInfo var3);

    private native int nativeRegisterFaceFeatureArray(long var1, FaceFeatureInfo[] var3);

    private native int nativeRemoveFaceFeature(long var1, int var3);

    private native int nativeUpdateFaceFeature(long var1, FaceFeatureInfo var3);

    private native FaceFeatureInfo nativeGetFaceFeature(long var1, int var3);

    private native int nativeGetFaceCount(long var1);

    private native int nativeGetAge(long var1, AgeInfo[] var3, ErrorInfo var4);

    private native int nativeGetGender(long var1, GenderInfo[] var3, ErrorInfo var4);

    private native LivenessParam nativeGetLivenessParam(long var1);

    private native int nativeSetLivenessParam(long var1, LivenessParam var3);

    private native int nativeGetLiveness(long var1, LivenessInfo[] var3, ErrorInfo var4);

    private native int nativeGetIrLiveness(long var1, LivenessInfo[] var3, ErrorInfo var4);

    private native int nativeGetMask(long var1, MaskInfo[] var3, ErrorInfo var4);

    private static native void nativeGetVersion(VersionInfo var0);

    private static native int nativeGetRuntimeABI();

    private static native int nativeSetCustomDeviceInfo(CustomDeviceInfo var0);

    public static RuntimeABI getRuntimeABI() {
        int runtimeCpuArch = FaceEngine.nativeGetRuntimeABI();
        switch (runtimeCpuArch) {
            case 1: {
                return RuntimeABI.ANDROID_ABI_ARM64;
            }
            case 2: {
                return RuntimeABI.ANDROID_ABI_ARM32;
            }
        }
        return RuntimeABI.ANDROID_ABI_UNSUPPORTED;
    }

    public static int getActiveDeviceInfo(Context context, ActiveDeviceInfo activeDeviceInfo) {
        return FaceEngine.nativeGetActiveDeviceInfo(context, activeDeviceInfo);
    }

    public static int setMACPriority(MACPriority macPriority) {
        if (macPriority == null) {
            return 2;
        }
        FaceEngine.nativeSetMACPriority(macPriority.getPriority());
        return 0;
    }

    public static int setDeviceIdPriority(DeviceIdPriority deviceIdPriority) {
        if (deviceIdPriority == null) {
            return 2;
        }
        FaceEngine.nativeSetDeviceIdPriority(deviceIdPriority.getPriority());
        return 0;
    }

    public static int setCustomDeviceInfo(CustomDeviceInfo customDeviceInfo) {
        if (customDeviceInfo == null) {
            return 2;
        }
        return FaceEngine.nativeSetCustomDeviceInfo(customDeviceInfo);
    }

    public static int activeOnline(Context context, String activeKey, String appId, String sdkKey) {
        if (context == null || activeKey == null || appId == null || sdkKey == null) {
            return 2;
        }
        return FaceEngine.nativeActiveFaceEngineOnline(context, activeKey, appId, sdkKey);
    }

    public static int activeOffline(Context context, String filePath) {
        if (context == null || filePath == null) {
            return 2;
        }
        return FaceEngine.nativeActiveFaceEngineOffline(context, filePath);
    }

    public static int getActiveFileInfo(Context context, ActiveFileInfo activeFileInfo) {
        if (activeFileInfo == null) {
            return 2;
        }
        return FaceEngine.nativeGetActiveFile(context, activeFileInfo);
    }

    public int init(Context context, DetectMode detectMode, DetectFaceOrientPriority detectFaceOrientPriority, int detectFaceMaxNum, int combinedMask) {
        if (this.handle != 0L) {
            return 5;
        }
        if (context == null || detectMode == null || detectFaceOrientPriority == null) {
            return 2;
        }
        this.handle = this.nativeInitFaceEngine(context, detectMode.getMode(), detectFaceOrientPriority.getPriority(), detectFaceMaxNum, combinedMask, this.initError);
        if (this.initError.getCode() == 0) {
            int i;
            if ((combinedMask & 1) != 0) {
                this.mFaceInfoArray = new FaceInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mFaceInfoArray[i] = new FaceInfo();
                }
            }
            if ((combinedMask & 8) != 0) {
                this.mAgeInfoArray = new AgeInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mAgeInfoArray[i] = new AgeInfo();
                }
            }
            if ((combinedMask & 0x10) != 0) {
                this.mGenderInfoArray = new GenderInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mGenderInfoArray[i] = new GenderInfo();
                }
            }
            if ((combinedMask & 0x80) != 0) {
                this.mLivenessInfoArray = new LivenessInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mLivenessInfoArray[i] = new LivenessInfo();
                }
            }
            if ((combinedMask & 0x400) != 0) {
                this.mIrLivenessInfoArray = new LivenessInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mIrLivenessInfoArray[i] = new LivenessInfo();
                }
            }
            if ((combinedMask & 0x1000) != 0) {
                this.mMaskInfoArray = new MaskInfo[detectFaceMaxNum];
                for (i = 0; i < detectFaceMaxNum; ++i) {
                    this.mMaskInfoArray[i] = new MaskInfo();
                }
            }
        }
        return this.initError.code;
    }

    public int unInit() {
        if (this.handle != 0L) {
            int unInitEngineCode = this.nativeUnInitFaceEngine(this.handle);
            if (unInitEngineCode == 0) {
                this.handle = 0L;
            }
            return unInitEngineCode;
        }
        return 5;
    }

    public int detectFaces(byte[] data, int width, int height, int format, List<FaceInfo> faceInfoList) {
        return this.detectFaces(data, width, height, format, DetectModel.RGB, faceInfoList);
    }

    public int detectFaces(byte[] data, int width, int height, int format, DetectModel detectModel, List<FaceInfo> faceInfoList) {
        if (format != 2050 && format != 513 && format != 1793 && format != 3074) {
            return 90126;
        }
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (faceInfoList == null || data == null || detectModel == null) {
            return 2;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        faceInfoList.clear();
        int count = this.nativeDetectFaces(this.handle, data, width, height, format, detectModel.getModel(), this.mFaceInfoArray, this.detectError);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                faceInfoList.add(new FaceInfo(this.mFaceInfoArray[i]));
            }
        }
        return this.detectError.code;
    }

    public int detectFaces(ArcSoftImageInfo arcSoftImageInfo, List<FaceInfo> faceInfoList) {
        return this.detectFaces(arcSoftImageInfo, DetectModel.RGB, faceInfoList);
    }

    public int detectFaces(ArcSoftImageInfo arcSoftImageInfo, DetectModel detectModel, List<FaceInfo> faceInfoList) {
        if (faceInfoList == null || arcSoftImageInfo == null) {
            return 2;
        }
        int imageFormat = arcSoftImageInfo.getImageFormat();
        if (imageFormat != 2050 && imageFormat != 513 && imageFormat != 1793 && imageFormat != 3074) {
            return 90126;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        faceInfoList.clear();
        int count = this.nativeDetectFaces(this.handle, arcSoftImageInfo, detectModel.getModel(), this.mFaceInfoArray, this.detectError);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                faceInfoList.add(new FaceInfo(this.mFaceInfoArray[i]));
            }
        }
        return this.detectError.code;
    }

    public int updateFaceData(byte[] data, int width, int height, int format, List<FaceInfo> faceInfoList) {
        if (format != 2050 && format != 513 && format != 1793 && format != 3074) {
            return 90126;
        }
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (faceInfoList == null || data == null) {
            return 2;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeUpdateFaceData(this.handle, data, width, height, format, faceInfoList.toArray(new FaceInfo[0]));
    }

    public int updateFaceData(ArcSoftImageInfo arcSoftImageInfo, List<FaceInfo> faceInfoList) {
        if (faceInfoList == null || arcSoftImageInfo == null) {
            return 2;
        }
        int imageFormat = arcSoftImageInfo.getImageFormat();
        if (imageFormat != 2050 && imageFormat != 513 && imageFormat != 1793 && imageFormat != 3074) {
            return 90126;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeUpdateFaceData(this.handle, arcSoftImageInfo, faceInfoList.toArray(new FaceInfo[0]));
    }

    public int process(byte[] data, int width, int height, int format, List<FaceInfo> faceInfoList, int combinedMask) {
        if (format != 2050 && format != 513) {
            return 90126;
        }
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (faceInfoList == null || data == null) {
            return 2;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        this.nativeProcess(this.handle, data, width, height, format, faceInfoList.toArray(new FaceInfo[0]), combinedMask, this.processError);
        return this.processError.code;
    }

    public int process(ArcSoftImageInfo arcSoftImageInfo, List<FaceInfo> faceInfoList, int combinedMask) {
        if (faceInfoList == null || arcSoftImageInfo == null) {
            return 2;
        }
        if (arcSoftImageInfo.getImageFormat() != 2050 && arcSoftImageInfo.getImageFormat() != 513) {
            return 90126;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        this.nativeProcess(this.handle, arcSoftImageInfo, faceInfoList.toArray(new FaceInfo[0]), combinedMask, this.processError);
        return this.processError.code;
    }

    public int processIr(byte[] data, int width, int height, int format, List<FaceInfo> faceInfoList, int combinedMask) {
        if (format != 2050 && format != 1793 && format != 3074) {
            return 90126;
        }
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (faceInfoList == null || data == null) {
            return 2;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        this.nativeProcessIr(this.handle, data, width, height, format, faceInfoList.toArray(new FaceInfo[0]), combinedMask, this.processIrError);
        return this.processIrError.code;
    }

    public int processIr(ArcSoftImageInfo arcSoftImageInfo, List<FaceInfo> faceInfoList, int combinedMask) {
        if (faceInfoList == null || arcSoftImageInfo == null) {
            return 2;
        }
        if (arcSoftImageInfo.getImageFormat() != 2050 && arcSoftImageInfo.getImageFormat() != 1793 && arcSoftImageInfo.getImageFormat() != 3074) {
            return 90126;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        this.nativeProcessIr(this.handle, arcSoftImageInfo, faceInfoList.toArray(new FaceInfo[0]), combinedMask, this.processIrError);
        return this.processIrError.code;
    }

    public int imageQualityDetect(byte[] data, int width, int height, int format, FaceInfo faceInfo, int isMask, ImageQualitySimilar imageQualitySimilar) {
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (faceInfo == null || data == null) {
            return 2;
        }
        if (format != 2050 && format != 1793 && format != 513) {
            return 90126;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        imageQualitySimilar.score = this.nativeImageQualityDetect(this.handle, data, width, height, format, faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, isMask, this.detectQualityError);
        return this.detectQualityError.code;
    }

    public int imageQualityDetect(ArcSoftImageInfo arcSoftImageInfo, FaceInfo faceInfo, int isMask, ImageQualitySimilar imageQualitySimilar) {
        if (faceInfo == null || arcSoftImageInfo == null) {
            return 2;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (arcSoftImageInfo.getImageFormat() != 2050 && arcSoftImageInfo.getImageFormat() != 1793 && arcSoftImageInfo.getImageFormat() != 513) {
            return 90126;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        imageQualitySimilar.score = this.nativeImageQualityDetect(this.handle, arcSoftImageInfo, faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, isMask, this.detectQualityError);
        return this.detectQualityError.code;
    }

    public int extractFaceFeature(byte[] data, int width, int height, int format, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (format != 2050 && format != 513 && format != 1793) {
            return 90126;
        }
        if (width <= 0 || height <= 0) {
            return 90127;
        }
        if (feature == null || feature.getFeatureData() == null || feature.getFeatureData().length < 2056 || faceInfo == null || extractType == null || data == null) {
            return 2;
        }
        if (!FaceEngine.isImageDataValid(data, width, height, format)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        if (mask != 1) {
            mask = 0;
        }
        this.nativeExtractFaceFeature(this.handle, data, width, height, format, faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, extractType.getExtractType(), mask, feature.getFeatureData(), this.frError);
        return this.frError.code;
    }

    public int extractFaceFeature(ArcSoftImageInfo arcSoftImageInfo, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (feature == null || feature.getFeatureData() == null || feature.getFeatureData().length < 2056 || faceInfo == null || extractType == null || arcSoftImageInfo == null) {
            return 2;
        }
        if (arcSoftImageInfo.getImageFormat() != 2050 && arcSoftImageInfo.getImageFormat() != 513 && arcSoftImageInfo.getImageFormat() != 1793) {
            return 90126;
        }
        if (arcSoftImageInfo.getWidth() <= 0 || arcSoftImageInfo.getHeight() <= 0) {
            return 90127;
        }
        if (!FaceEngine.isImageDataValid(arcSoftImageInfo)) {
            return 86021;
        }
        if (this.handle == 0L) {
            return 5;
        }
        if (mask != 1) {
            mask = 0;
        }
        this.nativeExtractFaceFeature(this.handle, arcSoftImageInfo, faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, extractType.getExtractType(), mask, feature.getFeatureData(), this.frError);
        return this.frError.code;
    }

    public int compareFaceFeature(FaceFeature feature1, FaceFeature feature2, FaceSimilar faceSimilar) {
        return this.compareFaceFeature(feature1, feature2, CompareModel.LIFE_PHOTO, faceSimilar);
    }

    public int compareFaceFeature(FaceFeature feature1, FaceFeature feature2, CompareModel compareModel, FaceSimilar faceSimilar) {
        if (feature1 == null || feature1.getFeatureData() == null || feature2 == null || feature2.getFeatureData() == null || faceSimilar == null || compareModel == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        faceSimilar.score = this.nativePairMatching(this.handle, feature1.getFeatureData(), feature2.getFeatureData(), compareModel.getModel(), this.frError);
        return this.frError.code;
    }

    public SearchResult searchFaceFeature(FaceFeature feature) throws IllegalArgumentException {
        return this.searchFaceFeature(feature, CompareModel.LIFE_PHOTO);
    }

    public SearchResult searchFaceFeature(FaceFeature feature, CompareModel compareModel) throws IllegalArgumentException {
        if (feature == null || feature.getFeatureData() == null || compareModel == null) {
            throw new IllegalArgumentException(String.format("%d: invalid parameters", 2));
        }
        if (this.handle == 0L) {
            throw new IllegalArgumentException(String.format("%d: bad state", 5));
        }
        return this.nativeSearchFaceFeature(this.handle, feature.getFeatureData(), compareModel.getModel());
    }

    public int registerFaceFeature(FaceFeatureInfo faceFeatureInfo) {
        if (faceFeatureInfo == null || faceFeatureInfo.getFeatureData() == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeRegisterFaceFeature(this.handle, faceFeatureInfo);
    }

    public int registerFaceFeature(List<FaceFeatureInfo> faceFeatureInfoList) {
        if (faceFeatureInfoList == null || faceFeatureInfoList.isEmpty()) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeRegisterFaceFeatureArray(this.handle, faceFeatureInfoList.toArray(new FaceFeatureInfo[0]));
    }

    public int removeFaceFeature(int searchId) {
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeRemoveFaceFeature(this.handle, searchId);
    }

    public int updateFaceFeature(FaceFeatureInfo faceFeatureInfo) {
        if (faceFeatureInfo == null || faceFeatureInfo.getFeatureData() == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeUpdateFaceFeature(this.handle, faceFeatureInfo);
    }

    public FaceFeatureInfo getFaceFeature(int searchId) throws IllegalArgumentException {
        if (this.handle == 0L) {
            throw new IllegalArgumentException(String.format("%d: bad state", 5));
        }
        return this.nativeGetFaceFeature(this.handle, searchId);
    }

    public int getFaceCount() throws IllegalArgumentException {
        if (this.handle == 0L) {
            throw new IllegalArgumentException(String.format("%d: bad state", 5));
        }
        return this.nativeGetFaceCount(this.handle);
    }

    public int getAge(List<AgeInfo> ageInfoList) {
        if (ageInfoList == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        ageInfoList.clear();
        int count = this.nativeGetAge(this.handle, this.mAgeInfoArray, this.processError);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ageInfoList.add(new AgeInfo(this.mAgeInfoArray[i]));
            }
        }
        return this.processError.code;
    }

    public int getGender(List<GenderInfo> genderInfoList) {
        if (genderInfoList == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        genderInfoList.clear();
        int count = this.nativeGetGender(this.handle, this.mGenderInfoArray, this.processError);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                genderInfoList.add(new GenderInfo(this.mGenderInfoArray[i]));
            }
        }
        return this.processError.code;
    }

    public LivenessParam getLivenessParam() throws IllegalArgumentException {
        if (this.handle == 0L) {
            throw new IllegalArgumentException(String.format("%d: bad state", 5));
        }
        return this.nativeGetLivenessParam(this.handle);
    }

    public int setLivenessParam(LivenessParam livenessParam) {
        if (livenessParam == null || livenessParam.getIrThreshold() > 1.0f || livenessParam.getIrThreshold() < 0.0f || livenessParam.getRgbThreshold() > 1.0f || livenessParam.getRgbThreshold() < 0.0f) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        return this.nativeSetLivenessParam(this.handle, livenessParam);
    }

    public int getLiveness(List<LivenessInfo> livenessInfoList) {
        if (livenessInfoList == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        livenessInfoList.clear();
        int count = this.nativeGetLiveness(this.handle, this.mLivenessInfoArray, this.processError);
        for (int i = 0; i < count; ++i) {
            livenessInfoList.add(new LivenessInfo(this.mLivenessInfoArray[i]));
        }
        return this.processError.code;
    }

    public int getIrLiveness(List<LivenessInfo> irLivenessInfoList) {
        if (irLivenessInfoList == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        irLivenessInfoList.clear();
        int count = this.nativeGetIrLiveness(this.handle, this.mIrLivenessInfoArray, this.processIrError);
        for (int i = 0; i < count; ++i) {
            irLivenessInfoList.add(new LivenessInfo(this.mIrLivenessInfoArray[i]));
        }
        return this.processIrError.code;
    }

    public int getMask(List<MaskInfo> maskInfoList) {
        if (maskInfoList == null) {
            return 2;
        }
        if (this.handle == 0L) {
            return 5;
        }
        maskInfoList.clear();
        int count = this.nativeGetMask(this.handle, this.mMaskInfoArray, this.processError);
        for (int i = 0; i < count; ++i) {
            maskInfoList.add(new MaskInfo(this.mMaskInfoArray[i]));
        }
        return this.processError.code;
    }

    public static int getVersion(VersionInfo versionInfo) {
        if (versionInfo == null) {
            return 2;
        }
        FaceEngine.nativeGetVersion(versionInfo);
        return 0;
    }

    private static boolean isImageDataValid(byte[] data, int width, int height, int format) {
        return format == 2050 && (height & 1) == 0 && data.length == width * height * 3 / 2 || format == 513 && data.length == width * height * 3 || format == 1793 && data.length == width * height || format == 3074 && data.length == width * height * 2;
    }

    private static boolean isImageDataValid(ArcSoftImageInfo arcSoftImageInfo) {
        byte[][] planes = arcSoftImageInfo.getPlanes();
        int[] strides = arcSoftImageInfo.getStrides();
        if (planes == null || strides == null) {
            return false;
        }
        if (planes.length != strides.length) {
            return false;
        }
        for (byte[] plane : planes) {
            if (plane != null && plane.length != 0) continue;
            return false;
        }
        switch (arcSoftImageInfo.getImageFormat()) {
            case 2050: {
                return (arcSoftImageInfo.getHeight() & 1) == 0 && planes.length == 2 && planes[0].length == planes[1].length * 2 && planes[0].length == arcSoftImageInfo.getStrides()[0] * arcSoftImageInfo.getHeight() && planes[1].length == arcSoftImageInfo.getStrides()[1] * arcSoftImageInfo.getHeight() / 2;
            }
            case 513: 
            case 1793: 
            case 3074: {
                return planes.length == 1 && planes[0].length == arcSoftImageInfo.getStrides()[0] * arcSoftImageInfo.getHeight();
            }
        }
        return false;
    }

    static {
        System.loadLibrary("arcsoft_face_engine");
    }
}

