package com.arcsoft.face;

/**
 * 人脸 属性阈值
 */
public class AttributeParam {

    /**
     * 睁眼幅度阈值，阈值越大睁眼幅度越大
     */
    private float eyeopenThreshold;

    /**
     * 张嘴幅度阈值，阈值越大，张嘴幅度越小
     */
    private float mouthcloseThreshold;

    /**
     * 佩戴眼镜阈值
     */
    private float wearGlassesThreshold;

    /**
     * 睁眼幅度阈值，阈值越大睁眼幅度越大
     * @return 睁眼幅度阈值
     */
    public float getEyeopenThreshold() {
        return eyeopenThreshold;
    }

    /**
     * 睁眼幅度阈值，阈值越大睁眼幅度越大
     * @param eyeopenThreshold 睁眼幅度阈值
     * @return 人脸 属性阈值
     */
    public AttributeParam setEyeopenThreshold(float eyeopenThreshold) {
        this.eyeopenThreshold = eyeopenThreshold;
        return this;
    }

    /**
     * 张嘴幅度阈值，阈值越大，张嘴幅度越小
     * @return 张嘴幅度阈值
     */
    public float getMouthcloseThreshold() {
        return mouthcloseThreshold;
    }

    /**
     * 张嘴幅度阈值，阈值越大，张嘴幅度越小
     * @param mouthcloseThreshold 张嘴幅度阈值
     * @return 人脸 属性阈值
     */
    public AttributeParam setMouthcloseThreshold(float mouthcloseThreshold) {
        this.mouthcloseThreshold = mouthcloseThreshold;
        return this;
    }

    /**
     * 佩戴眼镜阈值
     * @return 佩戴眼镜阈值
     */
    public float getWearGlassesThreshold() {
        return wearGlassesThreshold;
    }

    /**
     * 佩戴眼镜阈值
     * @param wearGlassesThreshold 佩戴眼镜阈值
     * @return 人脸 属性阈值
     */
    public AttributeParam setWearGlassesThreshold(float wearGlassesThreshold) {
        this.wearGlassesThreshold = wearGlassesThreshold;
        return this;
    }
}
