/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.face.toolkit;

import com.arcsoft.face.Rect;
import com.arcsoft.face.enums.ImageFormat;
import com.arcsoft.face.toolkit.ImageInfo;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageFactory {
    public static ImageInfo getRGBData(File file) {
        ImageInfo imageInfo;
        if (file == null) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(file);
            imageInfo = ImageFactory.bufferedImage2ImageInfo(image);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return imageInfo;
    }

    public static ImageInfo getGrayData(File file) {
        ImageInfo imageInfo;
        if (file == null) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(file);
            imageInfo = ImageFactory.bufferedImage2GrayImageInfo(image);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return imageInfo;
    }

    public static ImageInfo getRGBData(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ImageFactory.getRGBData(new ByteArrayInputStream(bytes));
    }

    public static ImageInfo getGrayData(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ImageFactory.getGrayData(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo getRGBData(InputStream input) {
        ImageInfo imageInfo;
        if (input == null) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(input);
            if (image == null) {
                ImageInfo imageInfo2 = null;
                return imageInfo2;
            }
            imageInfo = ImageFactory.bufferedImage2ImageInfo(image);
        }
        catch (IOException e) {
            ImageInfo imageInfo3 = null;
            return imageInfo3;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return imageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo getGrayData(InputStream input) {
        ImageInfo imageInfo;
        if (input == null) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(input);
            if (image == null) {
                ImageInfo imageInfo2 = null;
                return imageInfo2;
            }
            imageInfo = ImageFactory.bufferedImage2GrayImageInfo(image);
        }
        catch (IOException e) {
            ImageInfo imageInfo3 = null;
            return imageInfo3;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return imageInfo;
    }

    public static ImageInfo bufferedImage2ImageInfo(BufferedImage image) {
        byte[] targetData;
        byte[] frameData;
        int height;
        int w;
        int width = w = image.getWidth();
        int h = height = image.getHeight();
        BufferedImage res = new BufferedImage(width &= 0xFFFFFFFC, height &= 0xFFFFFFFC, 5);
        boolean conver = true;
        if (w == width && h == height && image.getType() == res.getType() && (frameData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData()).length == (targetData = ((DataBufferByte)res.getRaster().getDataBuffer()).getData()).length) {
            conver = false;
            System.arraycopy(frameData, 0, targetData, 0, Math.min(frameData.length, targetData.length));
        }
        if (conver) {
            Graphics2D g = res.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            g.dispose();
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width);
        imageInfo.setHeight(height);
        imageInfo.setImageFormat(ImageFormat.CP_PAF_RGB24);
        imageInfo.setImageData(((DataBufferByte)res.getRaster().getDataBuffer()).getData());
        return imageInfo;
    }

    public static ImageInfo bufferedImage2GrayImageInfo(BufferedImage image) {
        ImageInfo imageInfo = new ImageInfo();
        int width = image.getWidth();
        int height = image.getHeight();
        imageInfo.setWidth(width &= 0xFFFFFFFC);
        imageInfo.setHeight(height &= 0xFFFFFFFC);
        int[] rgb = image.getRGB(0, 0, width, height, null, 0, width);
        byte[] bytes = ImageFactory.rgbToGray(rgb, width, height);
        imageInfo.setImageFormat(ImageFormat.CP_PAF_GRAY);
        imageInfo.setImageData(bytes);
        return imageInfo;
    }

    private static byte[] rgbToGray(int[] argb, int width, int height) {
        int yIndex = 0;
        int index = 0;
        byte[] gray = new byte[width * height];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int R = (argb[index] & 0xFF0000) >> 16;
                int G = (argb[index] & 0xFF00) >> 8;
                int B = argb[index] & 0xFF;
                int Y = (66 * R + 129 * G + 25 * B + 128 >> 8) + 16;
                gray[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                ++index;
            }
        }
        return gray;
    }

    public static Rect getBestRect(int width, int height, Rect srcRect) {
        if (srcRect == null) {
            return null;
        }
        Rect rect = new Rect(srcRect);
        int maxOverFlow = Math.max(-rect.left, Math.min(-rect.top, Math.min(width - rect.right, height - rect.bottom)));
        if (maxOverFlow > 0) {
            rect.left += maxOverFlow;
            rect.top += maxOverFlow;
            rect.right -= maxOverFlow;
            rect.bottom -= maxOverFlow;
            return rect;
        }
        int padding = (rect.bottom - rect.top) / 2;
        if (rect.left - padding <= 0 || rect.right + padding >= width || rect.top - padding <= 0 || rect.bottom + padding >= height) {
            padding = Math.min(Math.min(Math.min(rect.left, width - rect.right), height - rect.bottom), rect.top);
        }
        rect.left -= padding;
        rect.top -= padding;
        rect.right += padding;
        rect.bottom += padding;
        return rect;
    }
}

