/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.face;

import com.arcsoft.face.ActiveDeviceInfo;
import com.arcsoft.face.ActiveFileInfo;
import com.arcsoft.face.AgeInfo;
import com.arcsoft.face.EngineConfiguration;
import com.arcsoft.face.FaceFeature;
import com.arcsoft.face.FaceFeatureInfo;
import com.arcsoft.face.FaceInfo;
import com.arcsoft.face.FaceSearchCount;
import com.arcsoft.face.FaceSimilar;
import com.arcsoft.face.FunctionConfiguration;
import com.arcsoft.face.GenderInfo;
import com.arcsoft.face.ImageQuality;
import com.arcsoft.face.IrLivenessInfo;
import com.arcsoft.face.LivenessInfo;
import com.arcsoft.face.LivenessParam;
import com.arcsoft.face.MaskInfo;
import com.arcsoft.face.Rect;
import com.arcsoft.face.SearchResult;
import com.arcsoft.face.VersionInfo;
import com.arcsoft.face.enums.CompareModel;
import com.arcsoft.face.enums.DetectModel;
import com.arcsoft.face.enums.ErrorInfo;
import com.arcsoft.face.enums.ExtractType;
import com.arcsoft.face.enums.ImageFormat;
import com.arcsoft.face.toolkit.ImageInfo;
import com.arcsoft.face.toolkit.ImageInfoEx;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class FaceEngine {
    private final int ASF_FACE_DETECT = 1;
    private final int ASF_FACE_RECOGNITION = 4;
    private final int ASF_AGE = 8;
    private final int ASF_GENDER = 16;
    private final int ASF_LIVENESS = 128;
    private final int ASF_IR_LIVENESS = 1024;
    private final int ASF_IMAGEQUALITY = 512;
    private final int ASF_MASKDETECT = 4096;
    private long handle = 0L;
    private int detectFaceMaxNum;
    private static final List<String> libCache = new LinkedList<String>();
    private static final String WIN_FACE_ENGINE_JNI_LIBRARY = "libarcsoft_face_engine_jni";
    private static final String LINUX_FACE_ENGINE_JNI_LIBRARY = "arcsoft_face_engine_jni";

    private native int nativeInitFaceEngine(long var1, int var3, int var4, int var5);

    private native int nativeActiveOnlineFaceEngine(String var1, String var2, String var3);

    private native int nativeActiveOfflineFaceEngine(String var1);

    private native int nativeGetActiveFile(ActiveFileInfo var1);

    private native int nativeUnInitFaceEngine(long var1);

    private native int nativeGetVersion(VersionInfo var1);

    private native int nativeDetectFaces(long var1, byte[] var3, int var4, int var5, int var6, int var7, FaceInfo[] var8);

    private native int nativeDetectFacesEx(long var1, byte[][] var3, int[] var4, int var5, int var6, int var7, int var8, FaceInfo[] var9);

    private native int nativeSetLivenessParam(long var1, float var3, float var4, float var5);

    private native int nativeGetLivenessParam(long var1, LivenessParam var3);

    private native int nativeProcess(long var1, byte[] var3, int var4, int var5, int var6, FaceInfo[] var7, int var8);

    private native int nativeProcessEx(long var1, byte[][] var3, int[] var4, int var5, int var6, int var7, FaceInfo[] var8, int var9);

    private native int nativeProcessIr(long var1, byte[] var3, int var4, int var5, int var6, FaceInfo[] var7, int var8);

    private native int nativeProcessIrEx(long var1, byte[][] var3, int[] var4, int var5, int var6, int var7, FaceInfo[] var8, int var9);

    private native int nativeExtractFaceFeature(long var1, byte[] var3, int var4, int var5, int var6, Rect var7, int var8, byte[] var9, int var10, int var11, int var12, byte[] var13);

    private native int nativeExtractFaceFeatureEx(long var1, byte[][] var3, int[] var4, int var5, int var6, int var7, Rect var8, int var9, byte[] var10, int var11, int var12, int var13, byte[] var14);

    private native int nativeFaceFeatureCompare(long var1, byte[] var3, byte[] var4, int var5, FaceSimilar var6);

    private native int nativeFaceSearch(long var1, byte[] var3, int var4, SearchResult var5);

    private native int nativeRegisterFaceFeatureArray(long var1, FaceFeatureInfo[] var3);

    private native int nativeRemoveFaceFeature(long var1, int var3);

    private native int nativeUpdateFaceFeature(long var1, FaceFeatureInfo var3);

    private native int nativeGetFaceFeature(long var1, int var3, FaceFeatureInfo var4);

    private native int nativeGetFaceCount(long var1, FaceSearchCount var3);

    private native int nativeGetAge(long var1, AgeInfo[] var3);

    private native int nativeGetGender(long var1, GenderInfo[] var3);

    private native int nativeGetLiveness(long var1, LivenessInfo[] var3);

    private native int nativeGetLivenessIr(long var1, IrLivenessInfo[] var3);

    private native int nativeGetMask(long var1, MaskInfo[] var3);

    private native int nativeGetActiveDeviceInfo(ActiveDeviceInfo var1);

    private native int nativeImageQualityDetect(long var1, byte[] var3, int var4, int var5, int var6, Rect var7, int var8, byte[] var9, int var10, int var11, ImageQuality var12);

    private native int nativeImageQualityDetectEx(long var1, byte[][] var3, int[] var4, int var5, int var6, int var7, Rect var8, int var9, byte[] var10, int var11, int var12, ImageQuality var13);

    private static synchronized void libraryLoad(String libPath) {
        if (libPath == null || libPath.length() == 0) {
            if (!libCache.contains(WIN_FACE_ENGINE_JNI_LIBRARY)) {
                String os = System.getProperty("os.name");
                if (os.toLowerCase().startsWith("win")) {
                    System.loadLibrary(WIN_FACE_ENGINE_JNI_LIBRARY);
                } else {
                    System.loadLibrary(LINUX_FACE_ENGINE_JNI_LIBRARY);
                }
                libCache.add(WIN_FACE_ENGINE_JNI_LIBRARY);
            }
        } else {
            if (libPath.endsWith("/") || libPath.endsWith("\\")) {
                libPath = libPath.substring(0, libPath.length() - 1);
            }
            if (!libCache.contains(libPath = libPath + File.separator)) {
                String os = System.getProperty("os.name");
                if (os.toLowerCase().startsWith("win")) {
                    System.load(libPath + "libarcsoft_face.dll");
                    System.load(libPath + "libarcsoft_face_engine.dll");
                    System.load(libPath + "libarcsoft_face_engine_jni.dll");
                } else {
                    System.load(libPath + "libarcsoft_face.so");
                    System.load(libPath + "libarcsoft_face_engine.so");
                    System.load(libPath + "libarcsoft_face_engine_jni.so");
                }
                libCache.add(libPath);
            }
        }
    }

    public FaceEngine() {
        FaceEngine.libraryLoad(null);
    }

    public FaceEngine(String libPath) {
        FaceEngine.libraryLoad(libPath);
    }

    public int activeOnline(String appId, String sdkKey, String activeKey) {
        if (appId == null) {
            appId = "";
        }
        if (sdkKey == null) {
            sdkKey = "";
        }
        if (activeKey == null) {
            activeKey = "";
        }
        int resultCode = this.nativeActiveOnlineFaceEngine(appId, sdkKey, activeKey);
        return resultCode;
    }

    public int activeOffline(String filePath) {
        if (filePath == null) {
            filePath = "";
        }
        int resultCode = this.nativeActiveOfflineFaceEngine(filePath);
        return resultCode;
    }

    public int getActiveFileInfo(ActiveFileInfo activeFileInfo) {
        int errorCode = this.nativeGetActiveFile(activeFileInfo);
        return errorCode;
    }

    public int init(EngineConfiguration engineConfiguration) {
        int detectFaceMaxNum;
        if (engineConfiguration == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        long detectMode = engineConfiguration.getDetectMode().getValue();
        int detectFaceOrientPriority = engineConfiguration.getDetectFaceOrientPriority().getValue();
        this.detectFaceMaxNum = detectFaceMaxNum = engineConfiguration.getDetectFaceMaxNum().intValue();
        int combinedMask = 0;
        if (engineConfiguration.getFunctionConfiguration().isSupportFaceDetect().booleanValue()) {
            combinedMask |= 1;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportFaceRecognition().booleanValue()) {
            combinedMask |= 4;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportAge().booleanValue()) {
            combinedMask |= 8;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportGender().booleanValue()) {
            combinedMask |= 0x10;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportLiveness().booleanValue()) {
            combinedMask |= 0x80;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportIRLiveness().booleanValue()) {
            combinedMask |= 0x400;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportImageQuality().booleanValue()) {
            combinedMask |= 0x200;
        }
        if (engineConfiguration.getFunctionConfiguration().isSupportMaskDetect().booleanValue()) {
            combinedMask |= 0x1000;
        }
        int errorCode = this.nativeInitFaceEngine(detectMode, detectFaceOrientPriority, detectFaceMaxNum, combinedMask);
        return errorCode;
    }

    public int unInit() {
        if (this.handle != 0L) {
            int errorCode = this.nativeUnInitFaceEngine(this.handle);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int setLivenessParam(float rgbThreshold, float irThreshold, float fqThreshold) {
        if (this.handle != 0L) {
            int errorCode = this.nativeSetLivenessParam(this.handle, rgbThreshold, irThreshold, fqThreshold);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int getLivenessParam(LivenessParam livenessParam) {
        if (livenessParam == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeGetLivenessParam(this.handle, livenessParam);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int detectFaces(byte[] data, int width, int height, ImageFormat imageFormat, List<FaceInfo> faceInfoList) {
        return this.detectFaces(data, width, height, imageFormat, DetectModel.ASF_DETECT_MODEL_RGB, faceInfoList);
    }

    public int detectFaces(ImageInfo imageInfo, List<FaceInfo> faceInfoList) {
        if (imageInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.detectFaces(imageInfo.getImageData(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getImageFormat(), DetectModel.ASF_DETECT_MODEL_RGB, faceInfoList);
    }

    public int detectFaces(byte[] data, int width, int height, ImageFormat imageFormat, DetectModel detectModel, List<FaceInfo> faceInfoList) {
        if (data == null || imageFormat == null || detectModel == null || faceInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(data, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        faceInfoList.clear();
        if (this.handle != 0L) {
            FaceInfo[] faceInfoArray = new FaceInfo[this.detectFaceMaxNum];
            int code = this.nativeDetectFaces(this.handle, data, width, height, imageFormat.getValue(), detectModel.getValue(), faceInfoArray);
            for (FaceInfo faceInfo : faceInfoArray) {
                if (faceInfo == null) break;
                faceInfoList.add(faceInfo);
            }
            return code;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int detectFaces(ImageInfoEx imageInfoEx, List<FaceInfo> faceInfoList) {
        if (imageInfoEx == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.detectFaces(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), DetectModel.ASF_DETECT_MODEL_RGB, faceInfoList);
    }

    public int detectFaces(ImageInfoEx imageInfoEx, DetectModel detectModel, List<FaceInfo> faceInfoList) {
        if (imageInfoEx == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.detectFaces(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), detectModel, faceInfoList);
    }

    private int detectFaces(byte[][] imageDataPlanes, int[] imageStrides, int width, int height, ImageFormat imageFormat, DetectModel detectModel, List<FaceInfo> faceInfoList) {
        if (imageDataPlanes == null || imageFormat == null || detectModel == null || faceInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(imageDataPlanes, imageStrides, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        faceInfoList.clear();
        if (this.handle != 0L) {
            FaceInfo[] faceInfoArray = new FaceInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeDetectFacesEx(this.handle, imageDataPlanes, imageStrides, width, height, imageFormat.getValue(), detectModel.getValue(), faceInfoArray);
            for (FaceInfo faceInfo : faceInfoArray) {
                if (faceInfo == null) break;
                faceInfoList.add(faceInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int process(ImageInfo imageInfo, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (imageInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.process(imageInfo.getImageData(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getImageFormat(), faceInfoList, functionConfiguration);
    }

    public int process(byte[] data, int width, int height, ImageFormat imageFormat, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (faceInfoList == null || data == null || imageFormat == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(data, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        int _combinedMask = 0;
        if (functionConfiguration.isSupportFaceDetect().booleanValue()) {
            _combinedMask |= 1;
        }
        if (functionConfiguration.isSupportFaceRecognition().booleanValue()) {
            _combinedMask |= 4;
        }
        if (functionConfiguration.isSupportAge().booleanValue()) {
            _combinedMask |= 8;
        }
        if (functionConfiguration.isSupportGender().booleanValue()) {
            _combinedMask |= 0x10;
        }
        if (functionConfiguration.isSupportLiveness().booleanValue()) {
            _combinedMask |= 0x80;
        }
        if (functionConfiguration.isSupportIRLiveness().booleanValue()) {
            _combinedMask |= 0x400;
        }
        if (functionConfiguration.isSupportImageQuality().booleanValue()) {
            _combinedMask |= 0x200;
        }
        if (functionConfiguration.isSupportMaskDetect().booleanValue()) {
            _combinedMask |= 0x1000;
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeProcess(this.handle, data, width, height, imageFormat.getValue(), faceInfoList.toArray(new FaceInfo[0]), _combinedMask);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int process(ImageInfoEx imageInfoEx, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (imageInfoEx == null || faceInfoList == null || functionConfiguration == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.process(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), faceInfoList, functionConfiguration);
    }

    private int process(byte[][] imageDataPlanes, int[] imageStrides, int width, int height, ImageFormat imageFormat, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (faceInfoList == null || imageDataPlanes == null || imageStrides == null || imageFormat == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(imageDataPlanes, imageStrides, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        int _combinedMask = 0;
        if (functionConfiguration.isSupportFaceDetect().booleanValue()) {
            _combinedMask |= 1;
        }
        if (functionConfiguration.isSupportFaceRecognition().booleanValue()) {
            _combinedMask |= 4;
        }
        if (functionConfiguration.isSupportAge().booleanValue()) {
            _combinedMask |= 8;
        }
        if (functionConfiguration.isSupportGender().booleanValue()) {
            _combinedMask |= 0x10;
        }
        if (functionConfiguration.isSupportLiveness().booleanValue()) {
            _combinedMask |= 0x80;
        }
        if (functionConfiguration.isSupportIRLiveness().booleanValue()) {
            _combinedMask |= 0x400;
        }
        if (functionConfiguration.isSupportImageQuality().booleanValue()) {
            _combinedMask |= 0x200;
        }
        if (functionConfiguration.isSupportMaskDetect().booleanValue()) {
            _combinedMask |= 0x1000;
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeProcessEx(this.handle, imageDataPlanes, imageStrides, width, height, imageFormat.getValue(), faceInfoList.toArray(new FaceInfo[0]), _combinedMask);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int processIr(ImageInfo imageInfo, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguratio) {
        if (faceInfoList == null || imageInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        int errorCode = this.processIr(imageInfo.getImageData(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getImageFormat(), faceInfoList, functionConfiguratio);
        return errorCode;
    }

    public int processIr(byte[] data, int width, int height, ImageFormat imageFormat, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (faceInfoList == null || data == null || imageFormat == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(data, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        int _combinedMask = 0;
        if (functionConfiguration.isSupportFaceDetect().booleanValue()) {
            _combinedMask |= 1;
        }
        if (functionConfiguration.isSupportFaceRecognition().booleanValue()) {
            _combinedMask |= 4;
        }
        if (functionConfiguration.isSupportAge().booleanValue()) {
            _combinedMask |= 8;
        }
        if (functionConfiguration.isSupportGender().booleanValue()) {
            _combinedMask |= 0x10;
        }
        if (functionConfiguration.isSupportLiveness().booleanValue()) {
            _combinedMask |= 0x80;
        }
        if (functionConfiguration.isSupportIRLiveness().booleanValue()) {
            _combinedMask |= 0x400;
        }
        if (functionConfiguration.isSupportImageQuality().booleanValue()) {
            _combinedMask |= 0x200;
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeProcessIr(this.handle, data, width, height, imageFormat.getValue(), faceInfoList.toArray(new FaceInfo[0]), _combinedMask);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int processIr(ImageInfoEx imageInfoEx, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (imageInfoEx == null || faceInfoList == null || functionConfiguration == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.processIr(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), faceInfoList, functionConfiguration);
    }

    private int processIr(byte[][] imageDataPlanes, int[] imageStrides, int width, int height, ImageFormat imageFormat, List<FaceInfo> faceInfoList, FunctionConfiguration functionConfiguration) {
        if (faceInfoList == null || imageDataPlanes == null || imageStrides == null || imageFormat == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(imageDataPlanes, imageStrides, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        int _combinedMask = 0;
        if (functionConfiguration.isSupportFaceDetect().booleanValue()) {
            _combinedMask |= 1;
        }
        if (functionConfiguration.isSupportFaceRecognition().booleanValue()) {
            _combinedMask |= 4;
        }
        if (functionConfiguration.isSupportAge().booleanValue()) {
            _combinedMask |= 8;
        }
        if (functionConfiguration.isSupportGender().booleanValue()) {
            _combinedMask |= 0x10;
        }
        if (functionConfiguration.isSupportLiveness().booleanValue()) {
            _combinedMask |= 0x80;
        }
        if (functionConfiguration.isSupportIRLiveness().booleanValue()) {
            _combinedMask |= 0x400;
        }
        if (functionConfiguration.isSupportImageQuality().booleanValue()) {
            _combinedMask |= 0x200;
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeProcessIrEx(this.handle, imageDataPlanes, imageStrides, width, height, imageFormat.getValue(), faceInfoList.toArray(new FaceInfo[0]), _combinedMask);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int extractFaceFeature(ImageInfo imageInfo, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (imageInfo == null || faceInfo == null || feature == null || extractType == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.extractFaceFeature(imageInfo.getImageData(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getImageFormat(), faceInfo, extractType, mask, feature);
    }

    public int extractFaceFeature(byte[] data, int width, int height, ImageFormat imageFormat, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (feature == null || imageFormat == null || feature.getFeatureData() == null || feature.getFeatureData().length < 2056 || faceInfo == null || data == null || extractType == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(data, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeExtractFaceFeature(this.handle, data, width, height, imageFormat.getValue(), faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, extractType.getExtractType(), mask, feature.featureData);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int extractFaceFeature(ImageInfoEx imageInfoEx, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (imageInfoEx == null || faceInfo == null || feature == null || extractType == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.extractFaceFeature(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), faceInfo, extractType, mask, feature);
    }

    private int extractFaceFeature(byte[][] imageDataPlanes, int[] imageStrides, int width, int height, ImageFormat imageFormat, FaceInfo faceInfo, ExtractType extractType, int mask, FaceFeature feature) {
        if (feature == null || imageFormat == null || feature.getFeatureData() == null || faceInfo == null || imageDataPlanes == null || imageStrides == null || extractType == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(imageDataPlanes, imageStrides, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeExtractFaceFeatureEx(this.handle, imageDataPlanes, imageStrides, width, height, imageFormat.getValue(), faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, extractType.getExtractType(), mask, feature.featureData);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int compareFaceFeature(FaceFeature feature1, FaceFeature feature2, FaceSimilar faceSimilar) {
        return this.compareFaceFeature(feature1, feature2, CompareModel.LIFE_PHOTO, faceSimilar);
    }

    public int compareFaceFeature(FaceFeature feature1, FaceFeature feature2, CompareModel compareModel, FaceSimilar faceSimilar) {
        if (feature1 == null || feature1.getFeatureData() == null || feature2 == null || feature2.getFeatureData() == null || faceSimilar == null || compareModel == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeFaceFeatureCompare(this.handle, feature1.featureData, feature2.featureData, compareModel.getValue(), faceSimilar);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int searchFaceFeature(FaceFeature faceFeature, SearchResult searchResult) {
        return this.searchFaceFeature(faceFeature, CompareModel.LIFE_PHOTO, searchResult);
    }

    public int searchFaceFeature(FaceFeature faceFeature, CompareModel compareModel, SearchResult searchResult) {
        if (faceFeature == null || faceFeature.getFeatureData() == null || compareModel == null || searchResult == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeFaceSearch(this.handle, faceFeature.featureData, compareModel.getValue(), searchResult);
    }

    public int registerFaceFeature(FaceFeatureInfo faceFeatureInfo) {
        if (faceFeatureInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (faceFeatureInfo.getFeatureData() == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeRegisterFaceFeatureArray(this.handle, new FaceFeatureInfo[]{faceFeatureInfo});
    }

    public int registerFaceFeature(List<FaceFeatureInfo> faceFeatureInfoList) {
        if (faceFeatureInfoList == null || faceFeatureInfoList.isEmpty()) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        for (FaceFeatureInfo faceFeatureInfo : faceFeatureInfoList) {
            if (faceFeatureInfo.getFeatureData() != null && faceFeatureInfo.getFeatureData().length == 2056) continue;
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeRegisterFaceFeatureArray(this.handle, faceFeatureInfoList.toArray(new FaceFeatureInfo[0]));
    }

    public int removeFaceFeature(int searchId) {
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeRemoveFaceFeature(this.handle, searchId);
    }

    public int updateFaceFeature(FaceFeatureInfo faceFeatureInfo) {
        if (faceFeatureInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeUpdateFaceFeature(this.handle, faceFeatureInfo);
    }

    public int getFaceFeature(int searchId, FaceFeatureInfo faceFeatureInfo) {
        if (faceFeatureInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeGetFaceFeature(this.handle, searchId, faceFeatureInfo);
    }

    public int getFaceCount(FaceSearchCount faceSearchCount) {
        if (faceSearchCount == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (this.handle == 0L) {
            return ErrorInfo.MERR_BAD_STATE.getValue();
        }
        return this.nativeGetFaceCount(this.handle, faceSearchCount);
    }

    public int getAge(List<AgeInfo> ageInfoList) {
        if (ageInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        ageInfoList.clear();
        if (this.handle != 0L) {
            AgeInfo[] faceInfoArray = new AgeInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeGetAge(this.handle, faceInfoArray);
            for (AgeInfo ageInfo : faceInfoArray) {
                if (ageInfo == null) break;
                ageInfoList.add(ageInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int getGender(List<GenderInfo> genderInfoList) {
        if (genderInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        genderInfoList.clear();
        if (this.handle != 0L) {
            GenderInfo[] genderInfos = new GenderInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeGetGender(this.handle, genderInfos);
            for (GenderInfo genderInfo : genderInfos) {
                if (genderInfo == null) break;
                genderInfoList.add(genderInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int getLiveness(List<LivenessInfo> livenessInfoList) {
        if (livenessInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        livenessInfoList.clear();
        if (this.handle != 0L) {
            LivenessInfo[] livenessInfos = new LivenessInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeGetLiveness(this.handle, livenessInfos);
            for (LivenessInfo livenessInfo : livenessInfos) {
                if (livenessInfo == null) break;
                livenessInfoList.add(livenessInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int getLivenessIr(List<IrLivenessInfo> livenessInfoList) {
        if (livenessInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        livenessInfoList.clear();
        if (this.handle != 0L) {
            IrLivenessInfo[] livenessInfos = new IrLivenessInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeGetLivenessIr(this.handle, livenessInfos);
            for (IrLivenessInfo livenessInfo : livenessInfos) {
                if (livenessInfo == null) break;
                livenessInfoList.add(livenessInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int getMask(List<MaskInfo> maskInfoList) {
        if (maskInfoList == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        maskInfoList.clear();
        if (this.handle != 0L) {
            MaskInfo[] maskInfos = new MaskInfo[this.detectFaceMaxNum];
            int errorCode = this.nativeGetMask(this.handle, maskInfos);
            for (MaskInfo maskInfo : maskInfos) {
                if (maskInfo == null) break;
                maskInfoList.add(maskInfo);
            }
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public VersionInfo getVersion() {
        VersionInfo versionInfo = new VersionInfo();
        this.nativeGetVersion(versionInfo);
        return versionInfo;
    }

    public int getActiveDeviceInfo(ActiveDeviceInfo activeDeviceInfo) {
        if (activeDeviceInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.nativeGetActiveDeviceInfo(activeDeviceInfo);
    }

    public int imageQualityDetect(ImageInfo imageInfo, FaceInfo faceInfo, int mask, ImageQuality imageQuality) {
        if (imageInfo == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.imageQualityDetect(imageInfo.getImageData(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getImageFormat(), faceInfo, mask, imageQuality);
    }

    private int imageQualityDetect(byte[] data, int width, int height, ImageFormat imageFormat, FaceInfo faceInfo, int mask, ImageQuality imageQuality) {
        if (data == null || imageFormat == null || faceInfo == null || imageQuality == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(data, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeImageQualityDetect(this.handle, data, width, height, imageFormat.getValue(), faceInfo.getRect(), faceInfo.getOrient(), faceInfo.getFaceData(), 5000, mask, imageQuality);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    public int imageQualityDetect(ImageInfoEx imageInfoEx, FaceInfo faceInfo, int mask, ImageQuality imageQuality) {
        if (imageInfoEx == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        return this.imageQualityDetect(imageInfoEx.getImageDataPlanes(), imageInfoEx.getImageStrides(), imageInfoEx.getWidth(), imageInfoEx.getHeight(), imageInfoEx.getImageFormat(), faceInfo, mask, imageQuality);
    }

    private int imageQualityDetect(byte[][] imageDataPlanes, int[] imageStrides, int width, int height, ImageFormat imageFormat, FaceInfo faceInfo, int mask, ImageQuality imageQuality) {
        if (faceInfo == null || imageDataPlanes == null || imageStrides == null || imageFormat == null || imageQuality == null) {
            return ErrorInfo.MERR_INVALID_PARAM.getValue();
        }
        if (width < 1 || height < 1) {
            return ErrorInfo.MERR_ASF_IMAGE_WIDTH_HEIGHT_NOT_SUPPORT.getValue();
        }
        if (!this.checkImageData(imageDataPlanes, imageStrides, width, height, imageFormat)) {
            return ErrorInfo.MERR_ASF_EX_INVALID_IMAGE_INFO.getValue();
        }
        if (this.handle != 0L) {
            int errorCode = this.nativeImageQualityDetectEx(this.handle, imageDataPlanes, imageStrides, width, height, imageFormat.getValue(), faceInfo.getRect(), faceInfo.orient, faceInfo.faceData, 5000, mask, imageQuality);
            return errorCode;
        }
        return ErrorInfo.MERR_BAD_STATE.getValue();
    }

    private boolean checkImageData(byte[] data, int width, int height, ImageFormat imageFormat) {
        switch (imageFormat) {
            case CP_PAF_NV21: 
            case CP_PAF_NV12: 
            case CP_PAF_I420: {
                if (data.length == width * height * 3 / 2) break;
                return false;
            }
            case CP_PAF_RGB24: {
                if (data.length == width * height * 3) break;
                return false;
            }
            case CP_PAF_GRAY: {
                if (data.length == width * height) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkImageData(byte[][] planes, int[] strides, int width, int height, ImageFormat imageFormat) {
        if (planes != null && strides != null) {
            if (planes.length != strides.length) {
                return false;
            }
            byte[][] var3 = planes;
            int var4 = planes.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                byte[] plane = var3[var5];
                if (plane != null && plane.length != 0) continue;
                return false;
            }
            switch (imageFormat) {
                case CP_PAF_NV21: {
                    return (height & 1) == 0 && planes.length == 2 && planes[0].length == planes[1].length * 2 && planes[0].length == strides[0] * height && planes[1].length == strides[1] * height / 2;
                }
                case CP_PAF_RGB24: 
                case CP_PAF_GRAY: {
                    return planes.length == 1 && planes[0].length == strides[0] * height;
                }
            }
            return false;
        }
        return false;
    }
}

